/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal.command;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public class EntityTypeArgument
implements ArgumentType<EntityType<?>> {
    private static final Collection<String> EXAMPLES = ImmutableList.of((Object)"item", (Object)"minecraft:pig", (Object)"minecraft:wither");
    private static final DynamicCommandExceptionType MISSING = new DynamicCommandExceptionType(p -> new TranslatableComponent("codechickenlib:argument.entity_type.invalid", new Object[]{p}));

    public EntityType<?> parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation loc = ResourceLocation.m_135818_((StringReader)reader);
        return (EntityType)Registry.f_122826_.m_6612_(loc).orElseThrow(() -> MISSING.create((Object)loc));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82957_(Registry.f_122826_.m_6566_().stream(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static EntityTypeArgument entityType() {
        return new EntityTypeArgument();
    }

    public static EntityType<?> getEntityType(CommandContext<CommandSourceStack> src, String name) {
        return (EntityType)src.getArgument(name, EntityType.class);
    }

    public static class Serializer
    implements ArgumentSerializer<EntityTypeArgument> {
        public void serializeToNetwork(EntityTypeArgument argument, FriendlyByteBuf buffer) {
        }

        public EntityTypeArgument deserializeFromNetwork(FriendlyByteBuf buffer) {
            return new EntityTypeArgument();
        }

        public void serializeToJson(EntityTypeArgument p_212244_1_, JsonObject p_212244_2_) {
        }
    }
}

